%------------------------------------------------------------------------------
% File     : SWB109^15 : TPTP v9.2.0. Released v8.1.0.
% Domain   : Semantic Web
% Problem  : Querying description logic knowledge bases
% Version  : [BP13] axioms.
% English  : 

% Refs     : [CD+07] Calvanese et al. (2007), EQL-Lite: Effective First-Ord
%          : [RO12]  Raths & Otten (2012), The QMLTP Problem Library for Fi
%          : [BP13]  Benzmueller & Paulson (2013), Quantified Multimodal Lo
%          : [Ste22] Steen (2022), An Extensible Logic Embedding Tool for L
% Source   : [TPTP]
% Names    : APM006+1 [QMLTP]

% Status   : CounterSatisfiable
% Rating   : 1.00 v9.0.0, 0.75 v8.2.0, 1.00 v8.1.0
% Syntax   : Number of formulae    :   41 (  12 unt;  24 typ;  10 def)
%            Number of atoms       :   75 (  10 equ;   0 cnn)
%            Maximal formula atoms :   21 (   4 avg)
%            Number of connectives :  110 (   1   ~;   1   |;   4   &;  99   @)
%                                         (   1 <=>;   4  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   15 (   4 avg)
%            Number of types       :    3 (   1 usr)
%            Number of type conns  :   68 (  68   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   24 (  23 usr;   7 con; 0-3 aty)
%            Number of variables   :   37 (  26   ^;   7   !;   4   ?;  37   :)
% SPC      : TH0_CSA_EQU_NAR

% Comments : This output was generated by embedproblem, version 1.7.1 (library
%            version 1.3). Generated on Thu Apr 28 13:18:18 EDT 2022 using
%            'modal' embedding, version 1.5.2. Logic specification used:
%            $modal == [$constants == $rigid,$quantification == $cumulative,
%            $modalities == $modal_system_D].
%------------------------------------------------------------------------------
thf(mworld,type,
    mworld: $tType ).

thf(mrel_type,type,
    mrel: mworld > mworld > $o ).

thf(mactual_type,type,
    mactual: mworld ).

thf(mlocal_type,type,
    mlocal: ( mworld > $o ) > $o ).

thf(mlocal_def,definition,
    ( mlocal
    = ( ^ [Phi: mworld > $o] : ( Phi @ mactual ) ) ) ).

thf(mnot_type,type,
    mnot: ( mworld > $o ) > mworld > $o ).

thf(mand_type,type,
    mand: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mor_type,type,
    mor: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mimplies_type,type,
    mimplies: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mequiv_type,type,
    mequiv: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mnot_def,definition,
    ( mnot
    = ( ^ [A: mworld > $o,W: mworld] :
          ~ ( A @ W ) ) ) ).

thf(mand_def,definition,
    ( mand
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
          & ( B @ W ) ) ) ) ).

thf(mor_def,definition,
    ( mor
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
          | ( B @ W ) ) ) ) ).

thf(mimplies_def,definition,
    ( mimplies
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
         => ( B @ W ) ) ) ) ).

thf(mequiv_def,definition,
    ( mequiv
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
        <=> ( B @ W ) ) ) ) ).

thf(mbox_type,type,
    mbox: ( mworld > $o ) > mworld > $o ).

thf(mbox_def,definition,
    ( mbox
    = ( ^ [Phi: mworld > $o,W: mworld] :
        ! [V: mworld] :
          ( ( mrel @ W @ V )
         => ( Phi @ V ) ) ) ) ).

thf(mdia_type,type,
    mdia: ( mworld > $o ) > mworld > $o ).

thf(mdia_def,definition,
    ( mdia
    = ( ^ [Phi: mworld > $o,W: mworld] :
        ? [V: mworld] :
          ( ( mrel @ W @ V )
          & ( Phi @ V ) ) ) ) ).

thf(mrel_serial,axiom,
    ! [W: mworld] :
    ? [V: mworld] : ( mrel @ W @ V ) ).

thf(eiw_di_type,type,
    eiw_di: $i > mworld > $o ).

thf(eiw_di_nonempty,axiom,
    ! [W: mworld] :
    ? [X: $i] : ( eiw_di @ X @ W ) ).

thf(eiw_di_cumul,axiom,
    ! [W: mworld,V: mworld,X: $i] :
      ( ( ( eiw_di @ X @ W )
        & ( mrel @ W @ V ) )
     => ( eiw_di @ X @ V ) ) ).

thf(mforall_di_type,type,
    mforall_di: ( $i > mworld > $o ) > mworld > $o ).

thf(mforall_di_def,definition,
    ( mforall_di
    = ( ^ [A: $i > mworld > $o,W: mworld] :
        ! [X: $i] :
          ( ( eiw_di @ X @ W )
         => ( A @ X @ W ) ) ) ) ).

thf(mexists_di_type,type,
    mexists_di: ( $i > mworld > $o ) > mworld > $o ).

thf(mexists_di_def,definition,
    ( mexists_di
    = ( ^ [A: $i > mworld > $o,W: mworld] :
        ? [X: $i] :
          ( ( eiw_di @ X @ W )
          & ( A @ X @ W ) ) ) ) ).

thf(ann_decl,type,
    ann: $i ).

thf(mary_decl,type,
    mary: $i ).

thf(bob_decl,type,
    bob: $i ).

thf(john_decl,type,
    john: $i ).

thf(paul_decl,type,
    paul: $i ).

thf(jane_decl,type,
    jane: $i ).

thf(parent_decl,type,
    parent: $i > $i > mworld > $o ).

thf(q2_decl,type,
    q2: $i > mworld > $o ).

thf(female_decl,type,
    female: $i > mworld > $o ).

thf(male_decl,type,
    male: $i > mworld > $o ).

thf(abox,axiom,
    mlocal @ ( mbox @ ( mand @ ( female @ mary ) @ ( mand @ ( female @ ann ) @ ( mand @ ( female @ jane ) @ ( mand @ ( male @ bob ) @ ( mand @ ( male @ john ) @ ( mand @ ( male @ paul ) @ ( mand @ ( parent @ bob @ mary ) @ ( mand @ ( parent @ bob @ ann ) @ ( mand @ ( parent @ john @ paul ) @ ( parent @ mary @ jane ) ) ) ) ) ) ) ) ) ) ) ).

thf(tbox,axiom,
    ( mlocal
    @ ( mforall_di
      @ ^ [X: $i] : ( mimplies @ ( mbox @ ( male @ X ) ) @ ( mbox @ ( mnot @ ( female @ X ) ) ) ) ) ) ).

thf(query,axiom,
    ( mlocal
    @ ( mforall_di
      @ ^ [X: $i] :
          ( mequiv @ ( q2 @ X )
          @ ( mand @ ( mbox @ ( male @ X ) )
            @ ( mnot
              @ ( mbox
                @ ( mexists_di
                  @ ^ [Y: $i] : ( mand @ ( parent @ X @ Y ) @ ( female @ Y ) ) ) ) ) ) ) ) ) ).

thf(con,conjecture,
    mlocal @ ( mand @ ( q2 @ john ) @ ( q2 @ paul ) ) ).

%------------------------------------------------------------------------------
